
// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f
 
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_FILTER_LINEAR;

static vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

static vec2 scale(vec2 uv, vec2 center, vec2 amp)
{

	return (uv + center)*(amp);

}
#define barScale 0.03f
static float bar(vec2 uv, float offset, float width)
{
	return  step(offset, uv.x) - step(offset + width, uv.x) ;
}
static float bars(vec2 uv, float process)
{
	
	//double blindFactor[] = {0.9, 0.8, 0.7, 0.6, 0.6, 0.7, 0.8, 0.9};
	 //return 0.6f*bar(uv, process + 0.3f*barScale, 0.6f*barScale ) + 0.7f* bar(uv, process + 1.2f*barScale,  0.7f*barScale )\
	 //+ 0.8f* bar(uv,process + 2.05f*barScale, 0.8f*barScale ) + 0.9f *bar(uv,process + 2.925f*barScale, 0.9f*barScale );
	float right =  0.6f*bar(uv, process + 0.3f*barScale, 0.6f*barScale ) + 0.7f* bar(uv, process + 1.3f*barScale,  0.7f*barScale )\
			+ 0.8f* bar(uv,process + 2.25f*barScale, 0.8f*barScale ) + 0.9f *bar(uv,process + 3.22f*barScale, 0.9f*barScale ) + bar(uv,process + 4.12f*barScale, 1000.0f*barScale );
	float left = 0.6f*bar(uv, process - 0.9f*barScale, 0.6f*barScale )+ 0.7f* bar(uv, process - 2.0f*barScale,  0.7f*barScale )\
			+ 0.8f* bar(uv,process - 3.05f*barScale, 0.8f*barScale ) + 0.9f *bar(uv,process - 4.12f*barScale, 0.9f*barScale ) + bar(uv,process -1000.0f*barScale, 995.88f*barScale );
	return left + right;
}

static float GetParabolaMap(float t, float T)	
{
	return (3.0f * T * t * t - 2.0f * t * t * t) / (T * T);
}

static float GetSinusoidalMap(float t, float T)	
{
	return t - T * sin(2.0f * PI * t / T) / (2.0f * PI);
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg, __global FilterParam* param)
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	float progress  = param->cur_time / param->total_time;
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int textH = param->height[2];
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = (vec2)(fragCoord.x, fragCoord.y)/resolution.xy;
	float iPro = GetSinusoidalMap(progress, 1.0f); 	
	iPro = GetParabolaMap(iPro, 1.0f) ;
	
	iPro = iPro *1.2472f - 0.1236f;
	float4 outputCol;
	float4 y1;
	
	if(uv.x > iPro)
	{
		y1  = INPUT(input1, param, uv) ; 
	}else
	{
		y1  = INPUT(input2,param, uv);
	}

	write_imagef(dstImg, (int2)(w, textH - h -1), (vec4)(bars(uv, iPro))*y1);
}
